/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import java.util.ArrayList;
import java.util.List;
import net.impactdev.impactor.relocations.com.mongodb.AcknowledgedBulkWriteResult;
import net.impactdev.impactor.relocations.com.mongodb.BulkWriteException;
import net.impactdev.impactor.relocations.com.mongodb.DBObject;
import net.impactdev.impactor.relocations.com.mongodb.DBObjects;
import net.impactdev.impactor.relocations.com.mongodb.MongoBulkWriteException;
import net.impactdev.impactor.relocations.com.mongodb.UnacknowledgedBulkWriteResult;
import net.impactdev.impactor.relocations.com.mongodb.WriteConcernError;
import net.impactdev.impactor.relocations.com.mongodb.bulk.BulkWriteError;
import net.impactdev.impactor.relocations.com.mongodb.bulk.BulkWriteResult;
import net.impactdev.impactor.relocations.com.mongodb.bulk.BulkWriteUpsert;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonDocumentReader;
import net.impactdev.impactor.relocations.org.bson.codecs.Decoder;
import net.impactdev.impactor.relocations.org.bson.codecs.DecoderContext;

final class BulkWriteHelper {
    static net.impactdev.impactor.relocations.com.mongodb.BulkWriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<net.impactdev.impactor.relocations.com.mongodb.BulkWriteUpsert> translateBulkWriteUpserts(List<BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<net.impactdev.impactor.relocations.com.mongodb.BulkWriteUpsert> retVal = new ArrayList<net.impactdev.impactor.relocations.com.mongodb.BulkWriteUpsert>(upserts.size());
        for (BulkWriteUpsert cur : upserts) {
            retVal.add(new net.impactdev.impactor.relocations.com.mongodb.BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static WriteConcernError translateWriteConcernError(net.impactdev.impactor.relocations.com.mongodb.bulk.WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<net.impactdev.impactor.relocations.com.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<net.impactdev.impactor.relocations.com.mongodb.BulkWriteError> retVal = new ArrayList<net.impactdev.impactor.relocations.com.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new net.impactdev.impactor.relocations.com.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

